select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ as Vorgangskennzeichen,

         sum(daten.Jahr1) as "Jahressumme vor 5 Jahren",
         sum(daten.Jahr2) as "Jahressumme vor 4 Jahren",
         sum(daten.Jahr3) as "Jahressumme vor 3 Jahren",
         sum(daten.Jahr4) as "Jahressumme vor 2 Jahren",
         sum(daten.Jahr5) as "Jahressumme vor 1 Jahr"

from     (
         select   'Basiszahl 29.3' as Bezeichnung,
                  nvl(k.kennzeichen,'(ohne)') as Kuerzel,
                  nvl(k.bezeichnung,'(ohne)') as VKZ,

                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-5)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-5
                                      and (m.bisdatum >= to_date('01.01.' || to_char(to_number(to_char(sysdate,'yyyy'))-5)) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Jahr1,
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-4)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-4
                                      and (m.bisdatum >= to_date('01.01.' || to_char(to_number(to_char(sysdate,'yyyy'))-4)) or m.bisdatum is null)
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Jahr2,
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-3)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-3
                                      and (m.bisdatum >= to_date('01.01.' || to_char(to_number(to_char(sysdate,'yyyy'))-3)) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Jahr3,   
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-2)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-2
                                      and (m.bisdatum >= to_date('01.01.' || to_char(to_number(to_char(sysdate,'yyyy'))-2)) or m.bisdatum is null)
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Jahr4,
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-1)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-1
                                      and (m.bisdatum >= to_date('01.01.' || to_char(to_number(to_char(sysdate,'yyyy'))-1)) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Jahr5   
                                      
         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_hzestatistik s on h.massnahme = s.massnahmennummer
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr

         where    s.artderhilfe in ('13')
         and      s.freigegeben = '1'
         and      s.ortdurchfuehrung in ('04','05','07')
          
          group by  nvl(k.kennzeichen,'(ohne)'),
                    nvl(k.bezeichnung,'(ohne)')

         ) daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ